<?php
	$dir_map_api=get_option('_dir_map_api');
?>
<script type='text/javascript' src='https://maps.googleapis.com/maps/api/js?libraries=places&key=<?php echo esc_html($dir_map_api);?>'></script>
<div class="profile-content">
	<span class="caption-subject"> <?php esc_html_e('Edit Listing','ivdirectories'); ?></span>
	<hr>
	<div class="portlet-body">
		<div class="" id="tab_1_1">
			<?php
				global $wpdb;
				// Check Max\
				$package_id=get_user_meta($current_user->ID,'iv_directories_package_id',true);
				$max=get_post_meta($package_id, 'iv_directories_package_max_post_no', true);
				$curr_post_id=$_REQUEST['post-id'];
				$current_post = $curr_post_id;
				$post_edit = get_post($curr_post_id);
				$have_edit_access='yes';
				$exp_date= get_user_meta($current_user->ID, 'iv_directories_exprie_date', true);
				if($exp_date!=''){
					$package_id=get_user_meta($current_user->ID,'iv_directories_package_id',true);
					$dir_hide= get_post_meta($package_id, 'iv_directories_package_hide_exp', true);
					if($dir_hide=='yes'){
						if(strtotime($exp_date) < time()){
							$have_edit_access='no';
						}
					}
				}
				if($post_edit->post_author != $current_user->ID ){
					$have_edit_access='no';
				}
				if(isset($current_user->roles[0]) and $current_user->roles[0]=='administrator'){
					$have_edit_access='yes';
				}
				if ( $have_edit_access=='no') {
					$iv_redirect = get_option( '_iv_directories_login_page');
					$reg_page= get_permalink( $iv_redirect);
				?>
				<?php esc_html_e('Please ','ivdirectories'); ?>
				<a href="<?php echo esc_html($reg_page).'?&profile=level'; ?>" ><b><?php esc_html_e('Login or upgrade ','ivdirectories'); ?> </b></a>
				<?php esc_html_e('To Edit The Post.','ivdirectories'); ?>
				<?php
					}else{
					$title = $post_edit->post_title;
					$content = $post_edit->post_content;
					$post_type=$post_edit->post_type;
				?>
				<div class="row">
					<div class="col-md-12">
						<form action="" id="edit_post" name="edit_post"  method="POST" role="form">
							<div class=" form-group">
								<label for="text" class=" control-label"><?php esc_html_e('Listing Type','ivdirectories'); ?></label>
								<div class="">
									<?php
										$cpt = array();
										$cpt_set=get_option('_iv_directory_url_postype' );
										if($cpt_set!=""){
											$cpt=get_option('_iv_directory_url_postype' );
											}else{
											$cpt['hotel']='Hotel';
											$cpt['restaurant']='Restaurant';
											$cpt['bar']='Bar';
										}
										$i=1;$old_select=$post_type;
										echo "<select id='cpt_page' name='cpt_page' class='form-control'>";
										foreach ( $cpt as $field_key => $field_value ) {
											echo "<option value='{$field_key}' ".($old_select==$field_key ? 'selected':'').">{$field_value}</option>";
										}
										echo "</select>";
									?>
								</div>
							</div>
							<div class=" form-group">
								<label for="text" class=" control-label"><?php esc_html_e('Name/Title','ivdirectories'); ?></label>
								<div class="  ">
									<input type="text" class="form-control" name="title" id="title"  placeholder="<?php esc_html_e('Enter listing Name Here','ivdirectories'); ?>" value="<?php echo esc_html($title);?>">
								</div>
							</div>
							<div class="form-group">
								<div class=" ">
									<?php
										$settings_a = array(
										'textarea_rows' =>8,
										'editor_class' => 'form-control',
										);
										$content_client =$content;
										$editor_id = 'edit_post_content';
										wp_editor($content_client, $editor_id,$settings_a );
									?>
								</div>
							</div>
							<div class=" row form-group ">
								<label for="text" class=" col-md-5 control-label"><?php esc_html_e('Logo','ivdirectories'); ?>  </label>
								<?php
									$logo_image_id=get_post_meta($curr_post_id ,'logo_image_id',true);
								?>
								<div class="col-md-4" id="logo_image_div">
									<a  href="javascript:void(0);" onclick="logo_post_image('logo_image_div');"  >
										<?php
											if($logo_image_id>0){
												echo '<img width="100px" src="'. wp_get_attachment_url( $logo_image_id ).'">';
												}else{
												echo '<img width="100px" src="'. wp_iv_directories_URLPATH.'assets/images/image-add-icon.png">';
											}
										?>
									</a>
								</div>
								<input type="hidden" name="logo_image_id" id="logo_image_id" value="<?php echo esc_html($logo_image_id); ?>">
								<div class="col-md-3" id="logo_image_edit">
									<button type="button" onclick="logo_post_image('logo_image_div');"  class="btn btn-xs green-haze"><?php esc_html_e('Add','ivdirectories'); ?> </button>
								</div>
							</div>
							<div class=" row form-group ">
								<label for="text" class=" col-md-5 control-label"><?php esc_html_e('Feature Image','ivdirectories'); ?>  </label>
								<div class="col-md-4" id="post_image_div">
									<?php $feature_image = wp_get_attachment_image_src( get_post_thumbnail_id( $curr_post_id ), 'thumbnail' );
										if(isset($feature_image[0]) AND $feature_image[0]!=""){ ?>
										<img title="profile image" class=" img-responsive" src="<?php  echo esc_html($feature_image[0]); ?>">
										<?php
										}else{ ?>
										<a href="javascript:void(0);" onclick="edit_post_image('post_image_div');"  >
											<?php  echo '<img src="'. wp_iv_directories_URLPATH.'assets/images/image-add-icon.png">'; ?>
										</a>
										<?php
										}
										$feature_image_id=get_post_thumbnail_id( $curr_post_id );
									?>
								</div>
								<input type="hidden" name="feature_image_id" id="feature_image_id" value="<?php echo esc_html($feature_image_id); ?>">
								<div class="col-md-3" id="post_image_edit">
									<button type="button" onclick="edit_post_image('post_image_div');"  class="btn btn-xs green-haze"><?php esc_html_e('Add','ivdirectories'); ?> </button>
								</div>
							</div>
							<div class=" row form-group ">
								<label for="text" class=" col-md-5 control-label"><?php esc_html_e('Image Gallery','ivdirectories'); ?>
									<button type="button" onclick="edit_gallery_image('gallery_image_div');"  class="btn btn-xs green-haze"><?php esc_html_e('Add Images','ivdirectories'); ?></button>
								</label>
							</div>
							<div class=" row form-group ">
								<?php
									$gallery_ids=get_post_meta($curr_post_id ,'image_gallery_ids',true); 									
									$gallery_ids_array = array_filter(explode(",", $gallery_ids));
								?>
								<input type="hidden" name="gallery_image_ids" id="gallery_image_ids" value="<?php echo esc_html($gallery_ids); ?>">
								<div class="col-md-12" id="gallery_image_div">
									<?php
										if(is_array($gallery_ids_array)){
											foreach($gallery_ids_array as $slide){
											?>
											<div id="gallery_image_div<?php echo esc_html($slide);?>" class="col-md-3"><img  class="img-responsive"  src="<?php echo wp_get_attachment_url( $slide ); ?>"><button type="button" onclick="remove_gallery_image('gallery_image_div<?php echo esc_html($slide);?>', <?php echo esc_html($slide);?>);"  class="btn btn-xs btn-danger">
											<?php esc_html_e('Remove', 'ivdirectories' ); ?></button> </div>
											<?php
											}
										}
									?>
								</div>
							</div>
							<div class="clearfix"></div>
							<div class=" row form-group ">
								<label for="text" class=" col-md-12 control-label"><?php esc_html_e('Post Status','ivdirectories'); ?>  </label>
								<div class="col-md-12" id="">
									<select name="post_status" id="post_status"  class="form-control">
										<?php
											$dir_approve_publish =get_option('_dir_approve_publish');
											if($dir_approve_publish!='yes'){?>
											<option value="publish" <?php echo (get_post_status( $post_edit->ID )=='publish'?'selected="selected"':'' ) ; ?>><?php esc_html_e('Publish','ivdirectories'); ?></option>
											<?php
												}else{
												if(isset($current_user->roles[0]) and $current_user->roles[0]=='administrator'){?>
												<option value="publish"><?php esc_html_e('Publish','ivdirectories'); ?></option>
												<?php
												}
											?>
											<option value="pending" <?php echo (get_post_status( $post_edit->ID )=='pending'?'selected="selected"':'' ) ; ?>><?php esc_html_e('Pending Review','ivdirectories'); ?></option>
											<?php
											}
										?>
										<option value="draft" <?php echo (get_post_status( $post_edit->ID )=='draft'?'selected="selected"':'' ) ; ?> ><?php esc_html_e('Draft', 'ivdirectories' ); ?></option>
									</select>
								</div>
							</div>
							<div class="clearfix"></div>
							<div class=" row form-group">
								<label for="text" class=" col-md-12 control-label"><?php esc_html_e('Category','ivdirectories'); ?></label>
								<div class=" col-md-12 " id="select_cpt">
									<?php
										$currentCategory=wp_get_object_terms( $post_edit->ID, $post_type.'-category');
										$post_cats=array();
										foreach($currentCategory as $c)
										{	if(isset($c->slug)){
											array_push($post_cats, $c->slug);
											}
										}
										$selected='';
										echo '<select name="postcats[]" class="form-control " multiple="multiple" size="8">';
										echo'	<option value="">'.esc_html__('Choose a category','ivdirectories').'</option>';
										//directories
										$taxonomy = $post_type.'-category';
										$args = array(
										'orderby'           => 'name',
										'order'             => 'ASC',
										'taxonomy'			=>  $post_type.'-category',
										'hide_empty'        => false,
										'exclude'           => array(),
										'exclude_tree'      => array(),
										'include'           => array(),
										'number'            => '',
										'fields'            => 'all',
										'slug'              => '',
										'parent'            => '0',
										'hierarchical'      => true,
										'child_of'          => 0,
										'childless'         => false,
										'get'               => '',
										);
										$terms = get_terms($args); // Get all terms of a taxonomy
										if ( $terms && !is_wp_error( $terms ) ) :
										$i=0;
										foreach ( $terms as $term_parent ) {
											if(in_array($term_parent->slug,$post_cats)){
												$selected=$term_parent->slug;
											}
										?>
										<?php
											echo '<option  value="'.$term_parent->slug.'" '.($selected==$term_parent->slug?'selected':'' ).'><strong>'.$term_parent->name.'<strong></option>';
										?>
										<?php
											$args2 = array(
											'type'                     => $post_type,
											'parent'                   => $term_parent->term_id,
											'orderby'                  => 'name',
											'order'                    => 'ASC',
											'hide_empty'               => 0,
											'hierarchical'             => 1,
											'exclude'                  => '',
											'include'                  => '',
											'number'                   => '',
											'taxonomy'                 => $post_type.'-category',
											'pad_counts'               => false
											);
											$categories = get_categories( $args2 );
											if ( $categories && !is_wp_error( $categories ) ) :
											foreach ( $categories as $term ) {
												if(in_array($term->slug,$post_cats)){
													$selected=$term->slug;
												}
												echo '<option  value="'.esc_html($term->slug).'" '.($selected==$term->slug?'selected':'' ).'>--'.esc_html($term->name).'</option>';
											}
											endif;
										?>
										<?php
											$i++;
										}
										endif;
										echo '</select>';
									?>
								</div>
							</div>
							<div class=" form-group row">
								<div class="col-md-6 "> 
									<label for="text" class=" control-label col-md-4 "><?php esc_html_e('Address','ivdirectories'); ?></label>							
									<input type="text" class="form-control col-md-8 " name="address" id="address"  value="<?php echo get_post_meta($post_edit->ID,'address',true); ?>" placeholder="<?php esc_html_e('Enter address Here','ivdirectories'); ?>">
								</div>							
								<div class=" col-md-6"> 
									<label for="text" class=" control-label col-md-4"><?php esc_html_e('Area','ivdirectories'); ?></label>							
									<input type="text" class="form-control col-md-8" name="area" id="area" value="<?php echo get_post_meta($post_edit->ID,'area',true); ?>" placeholder="<?php esc_html_e('Enter Area Here','ivdirectories'); ?>">
								</div>														
							</div>
							<div class=" form-group row">
								<div class="col-md-6 "> 
									<label for="text" class=" control-label col-md-4"><?php esc_html_e('City','ivdirectories'); ?></label>
									<input type="text" class="form-control col-md-8" name="city" id="city" value="<?php echo get_post_meta($post_edit->ID,'city',true); ?>" placeholder="<?php esc_html_e('Enter city ','ivdirectories'); ?>">
								</div>
								<div class=" col-md-6">
									<label for="text" class=" control-label col-md-4"><?php esc_html_e('Zipcode','ivdirectories'); ?></label>							
									<input type="text" class="form-control col-md-8" name="postcode" id="postcode" value="<?php echo get_post_meta($post_edit->ID,'postcode',true); ?>" placeholder="<?php esc_html_e('Enter Zipcode ','ivdirectories'); ?>">
								</div>
							</div>
							<div class=" form-group row">
								<div class=" col-md-6">
									<label for="text" class=" control-label col-md-4"><?php esc_html_e('State','ivdirectories'); ?></label>							
									<input type="text" class="form-control col-md-8" name="state" id="state" value="<?php echo get_post_meta($post_edit->ID,'state',true); ?>" placeholder="<?php esc_html_e('Enter State ','ivdirectories'); ?>">
								</div>
								<div class=" col-md-6">
									<label for="text" class=" control-label col-md-4"><?php esc_html_e('Country','ivdirectories'); ?></label>							
									<input type="text" class="form-control col-md-8" name="country" id="country" value="<?php echo get_post_meta($post_edit->ID,'country',true); ?>" placeholder="<?php esc_html_e('Enter Country ','ivdirectories'); ?>">
								</div>
							</div>	
							<div class=" form-group row">
								<div class=" col-md-6">
									<label for="text" class=" control-label "><?php esc_html_e('Latitude','ivdirectories'); ?></label>
									<input type="text" class="form-control " name="latitude" id="latitude" value="<?php echo get_post_meta($post_edit->ID,'latitude',true); ?>" placeholder="<?php esc_html_e('Enter latitude ','ivdirectories'); ?>">
								</div>
								<div class=" col-md-6">
									<label for="text" class=" control-label "><?php esc_html_e('Longitude','ivdirectories'); ?></label>	
									<input type="text" class="form-control " name="longitude" id="longitude" value="<?php echo get_post_meta($post_edit->ID,'longitude',true); ?>" placeholder="<?php esc_html_e('Enter longitude ','ivdirectories'); ?>">
								</div>
							</div>
							<div class=" form-group">
								<label for="text" class=" control-label"></label>
								<div class=" ">
									<div  id="map-canvas"></div>										
								</div>
							</div>
							<div class="clearfix"></div>
							<div class="panel panel-default">
								<div class="panel-heading">
									<h4 class="panel-title col-lg-10">
										<a data-toggle="collapse" data-parent="#accordion" href="#collapseEight">
											<?php esc_html_e('Speciality(s)','ivdirectories'); ?>
										</a>
									</h4>
									<h4 class="panel-title">
										<a data-toggle="collapse" data-parent="#accordion" href="#collapseEight">
											<?php esc_html_e('[ Edit ]','ivdirectories'); ?>
										</a>
									</h4>
								</div>
								<div id="collapseEight" class="panel-collapse collapse">
									<div class="panel-body">
										<div class=" form-group">
											<div class=" ">
												<?php
													$Specialities =esc_html__('Wheelchair access, Accept credit cards, Kids corner,Car parking,Pets friendly,Gift wrapping,Bike parking,Free Wi-Fi,Alcohol,Reservations,Street Parking,Breakfast and Meals,Chauffer Check-In,Pick Up/ Drop Off Service,Car parking,Luggage Forwarding Service,Pick Up/ Drop Off Service,Movie Library,Bar,Private Dining Hall,Rooftop Viewpoint,Tesla Supercharger,Locker Room,Hot tub,Fitness Centre','ivdirectories');
													$field_set=get_option('iv_listing_Specialities' );
													if($field_set!=""){
														$Specialities=get_option('iv_listing_Specialities' );
													}
													$i=1;
													$Specialities_fields= explode(",",$Specialities);
													$Specialitiess_saved = get_post_meta($post_edit->ID,'Specialities',true);
													$Specialitiess_arr = explode(",",$Specialitiess_saved);
													foreach ( $Specialities_fields as $field_value ) {
														if($field_value!='' ){
															$selected='';
															foreach ( $Specialitiess_arr as $field_1 ) {
																if(trim($field_1)==trim($field_value)){
																	$selected='checked';
																}
															}
														?>
														<div class="col-md-4">
															<label class="form-group">
															<input type="checkbox" <?php echo esc_html($selected); ?>  name="Specialities_arr[]" id="Specialities_arr[]" value="<?php echo esc_html($field_value); ?>"> <?php echo esc_html($field_value); ?> </label>
														</div>
														<?php
														}
													}
												?>
											</div>
										</div>
									</div>
								</div>
							</div>
							<div class="clearfix"></div>
							<div class="panel panel-default">
								<div class="panel-heading">
									<h4 class="panel-title col-lg-10">
										<a data-toggle="collapse" data-parent="#accordion" href="#collapseEight1">
											<?php esc_html_e('Tags','ivdirectories'); ?>
										</a>
									</h4>
									<h4 class="panel-title">
										<a data-toggle="collapse" data-parent="#accordion" href="#collapseEight1">
											<?php esc_html_e('[ Edit ]','ivdirectories'); ?>
										</a>
									</h4>
								</div>
								<div id="collapseEight1" class="panel-collapse collapse">
									<div class="panel-body">
										<div class=" form-group">
											
											<div id="iv_tags">
												<?php
													$args2 = array(
													'type'                     => $post_type,
													'orderby'                  => 'name',
													'order'                    => 'ASC',
													'hide_empty'               => 0,
													'hierarchical'             => 1,
													'exclude'                  => '',
													'include'                  => '',
													'number'                   => '',
													'taxonomy'                 => $post_type.'_tag',
													'pad_counts'               => false
													);
													$main_tag = get_categories( $args2 );
													$tags_all= wp_get_object_terms( $post_edit->ID,  $post_type.'_tag');
													if ( $main_tag && !is_wp_error( $main_tag ) ) :
													foreach ( $main_tag as $term_m ) {
														$checked='';
														foreach ( $tags_all as $term ) {
															if( $term->term_id==$term_m->term_id){
																$checked=' checked';
															}
														}
													?>
													<div class="col-md-4">
														<label class="form-group"> <input type="checkbox" name="tag_arr[]" id="tag_arr[]" <?php echo esc_html($checked);?> value="<?php echo esc_html($term_m->slug); ?>"> <?php echo esc_html($term_m->name); ?> </label>
													</div>
													<?php
													}
													endif;
												?>
											</div>
										</div>
										<div class="clearfix"></div>
										<div class=" form-group">
											<label for="text" class=" control-label"><?php esc_html_e('Add New Tags','ivdirectories'); ?></label>
											<div class="  ">
												<input type="text" class="form-control" name="new_tag" id="new_tag" value="" placeholder="<?php esc_html_e('Enter New Tags: Separate tags with commas','ivdirectories'); ?>">
											</div>
										</div>
									</div>
								</div>
							</div>
							<div class="panel panel-default">
								<div class="panel-heading">
									<h4 class="panel-title col-lg-10">
										<a data-toggle="collapse" data-parent="#accordion" href="#collapseFour">
											<?php esc_html_e('Contact Info','ivdirectories'); ?>
										</a>
									</h4>
									<h4 class="panel-title">
										<a data-toggle="collapse" data-parent="#accordion" href="#collapseFour">
											<?php esc_html_e('[ Edit ]','ivdirectories'); ?>
										</a>
									</h4>
								</div>
								<div id="collapseFour" class="panel-collapse collapse">
									<div class="panel-body">
										<div class=" form-group">
											<label for="text" class=" control-label"><?php esc_html_e('Phone','ivdirectories'); ?></label>
											<div class="  ">
												<input type="text" class="form-control" name="phone" id="phone" value="<?php echo get_post_meta($post_edit->ID,'phone',true); ?>" placeholder="<?php esc_html_e('Enter Phone Number','ivdirectories'); ?>">
											</div>
										</div>
										<div class=" form-group">
											<label for="text" class=" control-label"><?php esc_html_e('Fax','ivdirectories'); ?></label>
											<div class="  ">
												<input type="text" class="form-control" name="fax" id="fax" value="<?php echo get_post_meta($post_edit->ID,'fax',true); ?>" placeholder="<?php esc_html_e('Enter Fax Number','ivdirectories'); ?>">
											</div>
										</div>
										<div class=" form-group">
											<label for="text" class=" control-label"><?php esc_html_e('Email Address','ivdirectories'); ?></label>
											<div class="  ">
												<input type="text" class="form-control" name="contact-email" id="contact-email" value="<?php echo get_post_meta($post_edit->ID,'contact-email',true); ?>" placeholder="<?php esc_html_e('Enter Email Address','ivdirectories'); ?>">
											</div>
										</div>
										<div class=" form-group">
											<label for="text" class=" control-label"><?php esc_html_e('Web Site','ivdirectories'); ?></label>
											<div class="  ">
												<input type="text" class="form-control" name="contact_web" id="contact_web" value="<?php echo get_post_meta($post_edit->ID,'contact_web',true); ?>" placeholder="<?php esc_html_e('Enter Web Site','ivdirectories'); ?>">
											</div>
										</div>
									</div>
								</div>
							</div>
							<div class="clearfix"></div>
							<div class="panel panel-default">
								<div class="panel-heading">
									<h4 class="panel-title col-lg-10">
										<a data-toggle="collapse" data-parent="#accordion" href="#collapsethirty2">
											<?php esc_html_e('Awards','ivdirectories'); ?>
										</a>
									</h4>
									<h4 class="panel-title">
										<a data-toggle="collapse" data-parent="#accordion" href="#collapsethirty2">
											<?php esc_html_e('[ Edit ]','ivdirectories'); ?>
										</a>
									</h4>
								</div>
								<div id="collapsethirty2" class="panel-collapse collapse">
									<div class="panel-body">
										<?php
											// video, event ,  award
											if($this->check_write_access('award')){
											?>
											<div id="awards">
												<?php	$aw=0;
													for($i=0;$i<20;$i++){
														if(get_post_meta($post_edit->ID,'_award_title_'.$i,true)!='' || get_post_meta($post_edit->ID,'_award_description_'.$i,true) || get_post_meta($post_edit->ID,'_award_year_'.$i,true)|| get_post_meta($post_edit->ID,'_award_image_id_'.$i,true) ){?>
														<div id="award">
															<div id="award_delete_<?php echo esc_html($i); ?>">
																<div class=" form-group">
																	<span class="pull-right"  >
																		<button type="button" onclick="award_delete(<?php echo esc_html($i); ?>);"  class="btn btn-xs btn-danger">X</button>
																	</span>
																	<label for="text" class=" control-label"><?php esc_html_e('Award Title','ivdirectories'); ?>
																	</label>
																	<div class="  ">
																		<input type="text" class="form-control" name="award_title[]" id="award_title[]" value="<?php echo get_post_meta($post_edit->ID,'_award_title_'.$i,true); ?>" placeholder="<?php esc_html_e('Enter award title','ivdirectories'); ?>">
																	</div>
																</div>
																<div class=" form-group">
																	<label for="text" class=" control-label"><?php esc_html_e('Award Description','ivdirectories'); ?></label>
																	<div class="  ">
																		<input type="text" class="form-control" name="award_description[]" id="award_description[]" value="<?php echo get_post_meta($post_edit->ID,'_award_description_'.$i,true); ?>" placeholder="<?php esc_html_e('Enter Award Description','ivdirectories'); ?>">
																	</div>
																</div>
																<div class=" form-group">
																	<label for="text" class=" control-label"><?php esc_html_e('Year(s) for which award was received','ivdirectories'); ?></label>
																	<div class="  ">
																		<input type="text" class="form-control" name="award_year[]" id="award_year[]" value="<?php echo get_post_meta($post_edit->ID,'_award_year_'.$i,true); ?>" placeholder="<?php esc_html_e('Enter Award Year','ivdirectories'); ?>">
																	</div>
																</div>
																<div class=" form-group mgt10">
																	<label for="text" class=" col-md-5 control-label"><?php esc_html_e('Award Image','ivdirectories'); ?>  </label>
																	<div class="col-md-4" id="award_image_div">
																		<?php
																			if(get_post_meta($post_edit->ID,'_award_image_id_'.$i,true)!=''){?>
																			<a  href="javascript:void(0);" onclick="award_post_image(this);"  >
																				<img src="<?php echo wp_get_attachment_url( get_post_meta($post_edit->ID,'_award_image_id_'.$i,true) ); ?> " >
																				<input type="hidden" name="award_image_id[]" id="award_image_id[]" value="<?php echo get_post_meta($post_edit->ID,'_award_image_id_'.$i,true); ?>">
																			</a>
																			<?php
																			}else{?>
																			<a  href="javascript:void(0);" onclick="award_post_image(this);"  >
																				<?php  echo '<img width="100px" src="'. wp_iv_directories_URLPATH.'assets/images/image-add-icon.png">'; ?>
																			</a>
																			<?php
																			}
																		?>
																	</div>
																</div>
															</div>
														</div>
														<div class="clearfix"></div>
														<hr>
														<?php
															$aw++;
														}
													}
													if($aw==0){ ?>
													<div id="award">
														<div class=" form-group">
															<label for="text" class=" control-label"><?php esc_html_e('Award Title','ivdirectories'); ?></label>
															<div class="  ">
																<input type="text" class="form-control" name="award_title[]" id="award_title[]" value="" placeholder="<?php esc_html_e('Enter award title','ivdirectories'); ?>">
															</div>
														</div>
														<div class=" form-group">
															<label for="text" class=" control-label"><?php esc_html_e('Award Description','ivdirectories'); ?></label>
															<div class="  ">
																<input type="text" class="form-control" name="award_description[]" id="award_description[]" value="" placeholder="<?php esc_html_e('Enter Award Description','ivdirectories'); ?>">
															</div>
														</div>
														<div class=" form-group">
															<label for="text" class=" control-label"><?php esc_html_e('Year(s) for which award was received','ivdirectories'); ?></label>
															<div class="  ">
																<input type="text" class="form-control" name="award_year[]" id="award_year[]" value="" placeholder="<?php esc_html_e('Enter Award Year','ivdirectories'); ?>">
															</div>
														</div>
														<div class=" form-group mgt10">
															<label for="text" class=" col-md-5 control-label"><?php esc_html_e('Award Image','ivdirectories'); ?>  </label>
															<div class="col-md-4" id="award_image_div">
																<a  href="javascript:void(0);" onclick="award_post_image(this);"  >
																	<?php  echo '<img width="100px" src="'. wp_iv_directories_URLPATH.'assets/images/image-add-icon.png">'; ?>
																</a>
															</div>
														</div>
													</div>
													<?php
													}
												?>
											</div>
											<div class=" row  form-group ">
												<div class="col-md-12" >
													<button type="button" onclick="add_award_field();"  class="btn btn-xs green-haze"><?php esc_html_e('Add More','ivdirectories'); ?></button>
												</div>
											</div>
											<?php
												}else{
												esc_html_e('Please upgrade your account to add Award ','ivdirectories');
											}
										?>
									</div>
								</div>
							</div>
							<div class="panel panel-default">
								<div class="panel-heading">
									<h4 class="panel-title col-lg-10">
										<a data-toggle="collapse" data-parent="#accordion" href="#collapsethirty21">
											<?php esc_html_e('Food Menu','ivdirectories'); ?>
										</a>
									</h4>
									<h4 class="panel-title" >
										<a data-toggle="collapse" data-parent="#accordion" href="#collapsethirty21">
											<?php esc_html_e('[ Edit ]','ivdirectories'); ?>
										</a>
									</h4>
								</div>
								<div id="collapsethirty21" class="panel-collapse collapse">
									<div class="panel-body">
									
											<div id="menus">
												<?php	$aw=0;	 
													for($i=0;$i<50;$i++){
														if(get_post_meta($post_edit->ID,'_menu_title_'.$i,true)!='' || get_post_meta($post_edit->ID,'_menu_description_'.$i,true) || get_post_meta($post_edit->ID,'_menu_price_'.$i,true)|| get_post_meta($post_edit->ID,'_menu_image_id_'.$i,true) ){?>
														<div id="menu">
															<div id="menu_delete_<?php echo $i; ?>">
																<div class=" form-group">
																	<span class="pull-right"  > 
																		<button type="button" onclick="remove_menu(<?php echo $i; ?>);"  class="btn btn-xs btn-danger">X</button>
																	</span>
																	<label for="text" class=" control-label"><?php esc_html_e('Menu Title','ivdirectories'); ?>
																	</label>
																	<div class="  "> 
																		<input type="text" class="form-control" name="menu_title[]" id="menu_title[]" value="<?php echo get_post_meta($post_edit->ID,'_menu_title_'.$i,true); ?>" placeholder="<?php esc_html_e('Enter menu title','ivdirectories'); ?>">
																	</div>																
																</div>		
																<div class=" form-group">
																	<label for="text" class=" control-label"><?php esc_html_e('Menu Description','ivdirectories'); ?></label>
																	<div class="  "> 
																		<input type="text" class="form-control" name="menu_description[]" id="menu_description[]" value="<?php echo get_post_meta($post_edit->ID,'_menu_description_'.$i,true); ?>" placeholder="<?php esc_html_e('Enter Menu Description','ivdirectories'); ?>">
																	</div>																
																</div>
																<div class=" form-group">
																	<label for="text" class=" control-label"><?php esc_html_e('Price','ivdirectories'); ?></label>
																	<div class="  ">
																		<input type="text" class="form-control-solid" name="menu_price[]" id="menu_price[]" value="<?php echo get_post_meta($post_edit->ID,'_menu_price_'.$i,true); ?>" placeholder="<?php esc_html_e('Enter Menu Price','ivdirectories'); ?>">
																	</div>
																</div>
																<div class=" form-group">
																	<label for="text" class=" control-label"><?php esc_html_e('Order Now Link','ivdirectories'); ?></label>
																	<div class="  ">
																		<input type="text" class="form-control-solid" name="menu_order[]" id="menu_order[]" value="<?php echo get_post_meta($post_edit->ID,'_menu_order_'.$i,true); ?>" placeholder="<?php esc_html_e('Enter order now full link','ivdirectories'); ?>">
																	</div>
																</div>
																<div class=" form-group " style="margin-top:10px">
																	<label for="text" class=" col-md-5 control-label"><?php esc_html_e('Menu Image','ivdirectories'); ?>  </label>
																	<div class="col-md-4" id="menu_image_div">
																		<?php 
																			if(get_post_meta($post_edit->ID,'_menu_image_id_'.$i,true)!=''){?>
																			<a  href="javascript:void(0);" onclick="menu_post_image(this);"  >		
																				<img src="<?php echo wp_get_attachment_url( get_post_meta($post_edit->ID,'_menu_image_id_'.$i,true) ); ?> " >
																				<input type="hidden" name="menu_image_id[]" id="menu_image_id[]" value="<?php echo get_post_meta($post_edit->ID,'_menu_image_id_'.$i,true); ?>">
																			</a>
																			<?php
																			}else{?>
																			<a  href="javascript:void(0);" onclick="menu_post_image(this);"  >									
																				<?php  echo '<img width="100px" src="'. wp_iv_directories_URLPATH.'assets/images/image-add-icon.png">'; ?>			
																			</a>																					
																			<?php		
																			}																		
																		?>
																	</div>						
																</div>
															</div>		
														</div>	
														<div class="clearfix"></div>	 
														<hr>
														<?php
															$aw++;	
														}				 
													}
													if($aw==0){
													?>
													<div id="menu">
														<div class=" form-group">
															<label for="text" class=" control-label"><?php esc_html_e('Menu Title','ivdirectories'); ?></label>
															<div class="  ">
																<input type="text" class="form-control-solid" name="menu_title[]" id="menu_title[]" value="" placeholder="<?php esc_html_e('Enter menu title','ivdirectories'); ?>">
															</div>
														</div>
														<div class=" form-group">
															<label for="text" class=" control-label"><?php esc_html_e('Menu Description','ivdirectories'); ?></label>
															<div class="  ">
																<input type="text" class="form-control-solid" name="menu_description[]" id="menu_description[]" value="" placeholder="<?php esc_html_e('Enter menu Description','ivdirectories'); ?>">
															</div>
														</div>
														<div class=" form-group">
															<label for="text" class=" control-label"><?php esc_html_e('Price','ivdirectories'); ?></label>
															<div class="  ">
																<input type="text" class="form-control-solid" name="menu_price[]" id="menu_price[]" value="" placeholder="<?php esc_html_e('Enter Menu Price','ivdirectories'); ?>">
															</div>
														</div>
														<div class=" form-group">
															<label for="text" class=" control-label"><?php esc_html_e('Order Now Link','ivdirectories'); ?></label>
															<div class="  ">
																<input type="text" class="form-control-solid" name="menu_order[]" id="menu_order[]" value="" placeholder="<?php esc_html_e('Enter order now full link','ivdirectories'); ?>">
															</div>
														</div>
														<div class=" form-group " style="margin-top:10px">
															<label for="text" class=" col-md-5 control-label"><?php esc_html_e('Menu Image','ivdirectories'); ?>  </label>
															<div class="col-md-4" id="menu_image_div">
																<a  href="javascript:void(0);" onclick="menu_post_image(this);"  >
																	<?php  echo '<img width="100px" src="'. wp_iv_directories_URLPATH.'assets/images/image-add-icon.png">'; ?>
																</a>
															</div>
														</div>
													</div>
													<?php
													}
												?>																	
											</div>
											<div class=" row  form-group ">
												<div class="col-md-12" >
													<button type="button" onclick="add_menu_field();"  class="btn btn-xs green-haze"><?php esc_html_e('Add More','ivdirectories'); ?></button>
												</div>
											</div>
											
									</div>
								</div>
							</div>
							<div class="clearfix"></div>
							<div class="panel panel-default">
								<div class="panel-heading">
									<h4 class="panel-title col-lg-10">
										<a data-toggle="collapse" data-parent="#accordion" href="#collapsethirty22">
											<?php esc_html_e('Room','ivdirectories'); ?>
										</a>
									</h4>
									<h4 class="panel-title" >
										<a data-toggle="collapse" data-parent="#accordion" href="#collapsethirty22">
											<?php esc_html_e('[ Edit ]','ivdirectories'); ?>
										</a>
									</h4>
								</div>
								<div id="collapsethirty22" class="panel-collapse collapse">
									<div class="panel-body">
									
											<div id="rooms">
												<?php	$aw=0;	 
													for($i=0;$i<50;$i++){
														if(get_post_meta($post_edit->ID,'_room_title_'.$i,true)!='' || get_post_meta($post_edit->ID,'_room_description_'.$i,true) || get_post_meta($post_edit->ID,'_room_price_'.$i,true)|| get_post_meta($post_edit->ID,'_room_image_id_'.$i,true) ){?>
														<div id="room">
															<div id="room_delete_<?php echo $i; ?>">
																<div class=" form-group">
																	<span class="pull-right"  > 
																		<button type="button" onclick="remove_room(<?php echo $i; ?>);"  class="btn btn-xs btn-danger">X</button>
																	</span>
																	<label for="text" class=" control-label"><?php esc_html_e('Room Title','ivdirectories'); ?>
																	</label>
																	<div class="  "> 
																		<input type="text" class="form-control" name="room_title[]" id="room_title[]" value="<?php echo get_post_meta($post_edit->ID,'_room_title_'.$i,true); ?>" placeholder="<?php esc_html_e('Enter room title','ivdirectories'); ?>">
																	</div>																
																</div>		
																<div class=" form-group">
																	<label for="text" class=" control-label"><?php esc_html_e('Room Description','ivdirectories'); ?></label>
																	<div class="  "> 
																		<input type="text" class="form-control" name="room_description[]" id="room_description[]" value="<?php echo get_post_meta($post_edit->ID,'_room_description_'.$i,true); ?>" placeholder="<?php esc_html_e('Enter Room Description','ivdirectories'); ?>">
																	</div>																
																</div>
																<div class=" form-group">
																	<label for="text" class=" control-label"><?php esc_html_e('Price','ivdirectories'); ?></label>
																	<div class="  ">
																		<input type="text" class="form-control-solid" name="room_price[]" id="room_price[]" value="<?php echo get_post_meta($post_edit->ID,'_room_price_'.$i,true); ?>" placeholder="<?php esc_html_e('Enter Room Price','ivdirectories'); ?>">
																	</div>
																</div>
																<div class=" form-group">
																	<label for="text" class=" control-label"><?php esc_html_e('Order Now Link','ivdirectories'); ?></label>
																	<div class="  ">
																		<input type="text" class="form-control-solid" name="room_order[]" id="room_order[]" value="<?php echo get_post_meta($post_edit->ID,'_room_order_'.$i,true); ?>" placeholder="<?php esc_html_e('Enter order full link','ivdirectories'); ?>">
																	</div>
																</div>
																<div class=" form-group " style="margin-top:10px">
																	<label for="text" class=" col-md-5 control-label"><?php esc_html_e('Room Image','ivdirectories'); ?>  </label>
																	<div class="col-md-4" id="room_image_div">
																		<?php 
																			if(get_post_meta($post_edit->ID,'_room_image_id_'.$i,true)!=''){?>
																			<a  href="javascript:void(0);" onclick="room_post_image(this);"  >		
																				<img src="<?php echo wp_get_attachment_url( get_post_meta($post_edit->ID,'_room_image_id_'.$i,true) ); ?> " >
																				<input type="hidden" name="room_image_id[]" id="room_image_id[]" value="<?php echo get_post_meta($post_edit->ID,'_room_image_id_'.$i,true); ?>">
																			</a>
																			<?php
																			}else{?>
																			<a  href="javascript:void(0);" onclick="room_post_image(this);"  >									
																				<?php  echo '<img width="100px" src="'. wp_iv_directories_URLPATH.'assets/images/image-add-icon.png">'; ?>			
																			</a>																					
																			<?php		
																			}																		
																		?>
																	</div>						
																</div>
															</div>		
														</div>	
														<div class="clearfix"></div>	 
														<hr>
														<?php
															$aw++;	
														}				 
													}
													if($aw==0){
													?>
													<div id="room">
														<div class=" form-group">
															<label for="text" class=" control-label"><?php esc_html_e('Room Title','ivdirectories'); ?></label>
															<div class="  ">
																<input type="text" class="form-control-solid" name="room_title[]" id="room_title[]" value="" placeholder="<?php esc_html_e('Enter Room Title','ivdirectories'); ?>">
															</div>
														</div>
														<div class=" form-group">
															<label for="text" class=" control-label"><?php esc_html_e('Room Description','ivdirectories'); ?></label>
															<div class="  ">
																<input type="text" class="form-control-solid" name="room_description[]" id="room_description[]" value="" placeholder="<?php esc_html_e('Enter Room Description','ivdirectories'); ?>">
															</div>
														</div>
														<div class=" form-group">
															<label for="text" class=" control-label"><?php esc_html_e('Price','ivdirectories'); ?></label>
															<div class="  ">
																<input type="text" class="form-control-solid" name="room_price[]" id="room_price[]" value="" placeholder="<?php esc_html_e('Enter Room Price','ivdirectories'); ?>">
															</div>
														</div>
														<div class=" form-group">
															<label for="text" class=" control-label"><?php esc_html_e('Order Now Link','ivdirectories'); ?></label>
															<div class="  ">
																<input type="text" class="form-control-solid" name="room_order[]" id="room_order[]" value="" placeholder="<?php esc_html_e('Enter order full link','ivdirectories'); ?>">
															</div>
														</div>
														<div class=" form-group " style="margin-top:10px">
															<label for="text" class=" col-md-5 control-label"><?php esc_html_e('Room Image','ivdirectories'); ?>  </label>
															<div class="col-md-4" id="room_image_div">
																<a  href="javascript:void(0);" onclick="room_post_image(this);"  >
																	<?php  echo '<img width="100px" src="'. wp_iv_directories_URLPATH.'assets/images/image-add-icon.png">'; ?>
																</a>
															</div>
														</div>
													</div>
													<?php
													}
												?>	
											</div>
											<div class=" row  form-group ">
												<div class="col-md-12" >
													<button type="button" onclick="add_room_field();"  class="btn btn-xs green-haze"><?php esc_html_e('Add More','ivdirectories'); ?></button>
												</div>
											</div>
											
									</div>
								</div>
							</div>
							<div class="clearfix"></div>
							<div class="panel panel-default">
								<div class="panel-heading">
									<h4 class="panel-title col-lg-10">
										<a data-toggle="collapse" data-parent="#accordion" href="#collapse23">
											<?php esc_html_e('Booking Form','ivdirectories'); ?>
										</a>
									</h4>
									<h4 class="panel-title">
										<a data-toggle="collapse" data-parent="#accordion" href="#collapse23">
											<?php esc_html_e('[ Edit ]','ivdirectories'); ?>
										</a>
									</h4>
								</div>
								<div id="collapse23" class="panel-collapse collapse">
									<div class="panel-body">
										
											<div class=" form-group">
												<div class="radio">
													<label>
														<input type="radio" name="override_bookingf" id="override_bookingf" value="no" <?php echo(get_post_meta($post_edit->ID,'_booking_type',true)=='no'?'checked':''); ?>>
														<?php esc_html_e('Default Booking Form','ivdirectories'); ?> 
													</label>
												</div>	
												<div class="radio">
													<label>
														<input type="radio" name="override_bookingf" id="override_bookingf" value="yes" <?php echo(get_post_meta($post_edit->ID,'_booking_type',true)=='yes'?'checked':''); ?>>
														<?php esc_html_e('Add Shortcode','ivdirectories'); ?> 
													</label>
												</div>													
											</div>
											<div id="booking_sc" name="booking_sc" style="display: none">	  									
												<div class=" form-group" >
													<label for="text" class=" control-label"><?php esc_html_e('Shortcode','ivdirectories'); ?></label>						
													<div class="  "> 
														<input type="text" class="" name="booking_stcode" id="booking_stcode" value="<?php echo get_post_meta($post_edit->ID,'_booking_stcode',true);?>" placeholder="<?php esc_html_e('Enter Booking Shortcode','ivdirectories'); ?>">
													</div>																
												</div>
											</div>		
											
									</div>
								</div>
							</div>
							
							<div class="clearfix"></div>
							<div class="panel panel-default">
								<div class="panel-heading">
									<h4 class="panel-title col-lg-10">
										<a data-toggle="collapse" data-parent="#accordion" href="#collapseThree">
											<?php esc_html_e('Videos','ivdirectories'); ?>
										</a>
									</h4>
									<h4 class="panel-title">
										<a data-toggle="collapse" data-parent="#accordion" href="#collapseThree">
											<?php esc_html_e('[ Edit ]','ivdirectories'); ?>
										</a>
									</h4>
								</div>
								<div id="collapseThree" class="panel-collapse collapse">
									<div class="panel-body">
										<?php
											// video, event , coupon , vip_badge
											if($this->check_write_access('video')){
											?>
											<div class=" form-group">
												<label for="text" class=" control-label"><?php esc_html_e('Youtube','ivdirectories'); ?></label>
												<div class="  ">
													<input type="text" class="form-control" name="youtube" id="youtube" value="<?php echo get_post_meta($post_edit->ID,'youtube',true); ?>" placeholder="<?php esc_html_e('Enter Youtube video ID, e.g : bU1QPtOZQZU ','ivdirectories'); ?>">
												</div>
											</div>
											<div class=" form-group">
												<label for="text" class=" control-label"><?php esc_html_e('Vimeo','ivdirectories'); ?></label>
												<div class="  ">
													<input type="text" class="form-control" name="vimeo" id="vimeo" value="<?php echo get_post_meta($post_edit->ID,'vimeo',true); ?>" placeholder="<?php esc_html_e('Enter vimeo ID, e.g : 134173961','ivdirectories'); ?>">
												</div>
											</div>
											<?php
												}else{
												esc_html_e('Please upgrade your account to add video ','ivdirectories');
											}
										?>
									</div>
								</div>
							</div>
							<div class="clearfix"></div>
							<div class="panel panel-default">
								<div class="panel-heading">
									<h4 class="panel-title col-lg-10">
										<a data-toggle="collapse" data-parent="#accordion" href="#collapseFive">
											<?php esc_html_e('Social Profiles','ivdirectories'); ?>
										</a>
									</h4>
									<h4 class="panel-title">
										<a data-toggle="collapse" data-parent="#accordion" href="#collapseFive">
											<?php esc_html_e('[ Edit ]','ivdirectories'); ?>
										</a>
									</h4>
								</div>
								<div id="collapseFive" class="panel-collapse collapse">
									<div class="panel-body">
										<div class="form-group">
											<label class="control-label">
											<?php esc_html_e('FaceBook', 'ivdirectories' ); ?></label>
											<input type="text" name="facebook" id="facebook" value="<?php echo get_post_meta($post_edit->ID,'facebook',true); ?>" class="form-control"/>
										</div>
										<div class="form-group">
											<label class="control-label"><?php esc_html_e('Linkedin', 'ivdirectories' ); ?></label>
											<input type="text" name="linkedin" id="linkedin" value="<?php echo get_post_meta($post_edit->ID,'linkedin',true); ?>" class="form-control"/>
										</div>
										<div class="form-group">
											<label class="control-label"><?php esc_html_e('Twitter', 'ivdirectories' ); ?></label>
											<input type="text" name="twitter" id="twitter" value="<?php echo get_post_meta($post_edit->ID,'twitter',true); ?>" class="form-control"/>
										</div>
										<div class="form-group">
											<label class="control-label"><?php esc_html_e('Pinterest', 'ivdirectories' ); ?></label>
											<input type="text" name="pinterest" id="pinterest" value="<?php echo get_post_meta($post_edit->ID,'pinterest',true); ?>"  class="form-control"/>
										</div>
										<div class="form-group">
											<label class="control-label"><?php esc_html_e('Instagram', 'ivdirectories' ); ?> </label>
											<input type="text" name="instagram" id="instagram" value="<?php echo get_post_meta($post_edit->ID,'instagram',true); ?>"  class="form-control"/>
										</div>
									</div>
								</div>
							</div>
							<div class="clearfix"></div>
							<div class="panel panel-default">
								<div class="panel-heading">
									<h4 class="panel-title col-lg-10">
										<a data-toggle="collapse" data-parent="#accordion" href="#collapseTwo">
											<?php esc_html_e('Additional Info','ivdirectories'); ?>
										</a>
									</h4>
									<h4 class="panel-title">
										<a data-toggle="collapse" data-parent="#accordion" href="#collapseTwo">
											<?php esc_html_e('[ Edit ]','ivdirectories'); ?>
										</a>
									</h4>
								</div>
								<div id="collapseTwo" class="panel-collapse collapse">
									<div class="panel-body">
										<?php
											$default_fields = array();
											$field_set=get_option('iv_directories_fields' );
											if($field_set!=""){
												$default_fields=get_option('iv_directories_fields' );
												}else{
												$default_fields['Rooms']='Rooms';
												$default_fields['suites']='Suites';
												$default_fields['Rating_stars']='Rating Stars';
												$default_fields['CHECK_IN']='Check In';
												$default_fields['CHECK_out']='Check Out';
												$default_fields['Cancellation']='Cancellation';
												$default_fields['Pets']='Pets';
												$default_fields['Children_and_Extra_Beds']='Children and Extra Beds';	
											}
											$i=1;
											foreach ( $default_fields as $field_key => $field_value ) { ?>
											<div class="form-group">
												<label class="control-label"><?php echo esc_html($field_value); ?></label>
												<input type="text" placeholder="" name="<?php echo esc_html($field_key);?>" id="<?php echo esc_html($field_key);?>"  class="form-control" value="<?php echo get_post_meta($post_edit->ID,$field_key,true); ?>"/>
											</div>
											<?php
											}
										?>
									</div>
								</div>
							</div>
							<div class="panel panel-default">
								<div class="panel-heading">
									<h4 class="panel-title col-lg-10">
										<a data-toggle="collapse" data-parent="#accordion" href="#collapseOne">
											<?php esc_html_e('Working Time','ivdirectories'); ?>
										</a>
									</h4>
									<h4 class="panel-title">
										<a data-toggle="collapse" data-parent="#accordion" href="#collapseOne">
											<?php esc_html_e('[ Edit ]','ivdirectories'); ?>
										</a>
									</h4>
								</div>
								<div id="collapseOne" class="panel-collapse collapse">
									<div class="panel-body">
										<?php
											$opeing_days = get_post_meta($post_edit->ID ,'_opening_time',true);
											if($opeing_days!=''){?>
											<?php
												$i=1;
												if(is_array($opeing_days)){
													foreach($opeing_days as $key => $item){
														$day_time = explode("|", $item);
														echo '<div id="old_days'. $i .'">
														<div class="col-md-4"><h5>'.$key.'</h5></div> <div class="col-md-7"> <h5>: '.$day_time[0].' - '.$day_time[1].'</h5></div><div class="col-md-1"> <button type="button" onclick="remove_old_day('.$i.');"  class="btn btn-xs btn-danger">X</button>
														</div>
														<input type="hidden" name="day_name[]" id="day_name[]" value="'.$key.'">
														<input type="hidden" name="day_value1[]" id="day_value1[]" value="'.$day_time[0].'">
														<input type="hidden" name="day_value2[]" id="day_value2[]" value="'.$day_time[1].'">
														</div>
														';
														$i++;
													}
												}
											}
										?>
										<div id="day_field_div">
											<div class=" row form-group " id="day-row1" >
												<div class=" col-md-4">
													<select name="day_name[]" id="day_name[]" class="form-control">
														<option value=""></option>
														<option value="<?php esc_html_e('Monday','ivdirectories'); ?> "> <?php esc_html_e('Monday','ivdirectories'); ?>  </option>
														<option value="<?php esc_html_e('Tuesday','ivdirectories'); ?>"><?php esc_html_e('Tuesday','ivdirectories'); ?></option>
														<option value="<?php esc_html_e('Wednesday','ivdirectories'); ?>"><?php esc_html_e('Wednesday','ivdirectories'); ?></option>
														<option value="<?php esc_html_e('Thursday','ivdirectories'); ?>"><?php esc_html_e('Thursday','ivdirectories'); ?></option>
														<option value="<?php esc_html_e('Friday','ivdirectories'); ?>"><?php esc_html_e('Friday','ivdirectories'); ?></option>
														<option value="<?php esc_html_e('Saturday','ivdirectories'); ?>"><?php esc_html_e('Saturday','ivdirectories'); ?></option>
														<option value="<?php esc_html_e('Sunday','ivdirectories'); ?>"><?php esc_html_e('Sunday','ivdirectories'); ?></option>
													</select>
												</div>
												<div  class=" col-md-4">
													<input type="text" placeholder="<?php esc_html_e('12:00 AM','ivdirectories'); ?> " name="day_value1[]" id="day_value1[]"  class="form-control" />
												</div>
												<div  class="col-md-4">
													<input type="text" placeholder="<?php esc_html_e('12:00 AM','ivdirectories'); ?> " name="day_value2[]" id="day_value2[]"  class="form-control" />
												</div>
											</div>
										</div>
										<div class=" row  form-group ">
											<div class="col-md-12" >
												<button type="button" onclick="add_day_field();"  class="btn btn-xs green-haze"><?php esc_html_e('Add More','ivdirectories'); ?></button>
											</div>
										</div>
									</div>
								</div>
							</div>
							<div class="clearfix"></div>
							<div class="panel panel-default">
								<div class="panel-heading">
									<h4 class="panel-title col-lg-10">
										<a data-toggle="collapse" data-parent="#accordion" href="#collapseSix">
											<?php esc_html_e('Event','ivdirectories'); ?>
										</a>
									</h4>
									<h4 class="panel-title">
										<a data-toggle="collapse" data-parent="#accordion" href="#collapseSix">
											<?php esc_html_e('[ Edit ]','ivdirectories'); ?>
										</a>
									</h4>
								</div>
								<div id="collapseSix" class="panel-collapse collapse">
									<div class="panel-body">
										<?php
											// video, event , coupon , vip_badge , booking
											if($this->check_write_access('event')){
											?>
											<div class=" form-group">
												<label for="text" class=" control-label"><?php esc_html_e('Event Title','ivdirectories'); ?></label>
												<input type="text" class="form-control" name="event-title" id="event-title" value="<?php echo get_post_meta($post_edit->ID,'event_title',true); ?>" placeholder="<?php esc_html_e('Enter Title Here','ivdirectories'); ?>">
											</div>
											<div class=" form-group">
												<label for="text" class=" control-label"><?php esc_html_e('Event Detail','ivdirectories'); ?></label>
												<?php
													$settings_a = array(
													'textarea_rows' =>10,
													'editor_class' => 'form-control'
													);
													$content_client = get_post_meta($post_edit->ID,'event_detail',true);
													$editor_id = 'event-detail';
												?>
												<textarea id="event-detail" name="event-detail"  rows="4" class="form-control" > <?php echo esc_html($content_client); ?> </textarea>
											</div>
											<div class=" row form-group mgt10">
												<label for="text" class=" col-md-5 control-label"><?php esc_html_e('Event Image','ivdirectories'); ?>  </label>
												<div class="col-md-4" id="event_image_div">
													<?php
														if(get_post_meta($post_edit->ID,'_event_image_id',true)!=''){
															$event_image_src= wp_get_attachment_url( get_post_meta($post_edit->ID,'_event_image_id',true) );
														?>
														<img  class="img-responsive"  src="<?php echo esc_html($event_image_src); ?>">
														<?php
														}else{ ?>
														<a  href="javascript:void(0);" onclick="event_post_image('event_image_div');"  >
															<?php  echo '<img width="100px" src="'. wp_iv_directories_URLPATH.'assets/images/image-add-icon.png">'; ?>
														</a>
														<?php
														}
													?>
												</div>
												<div class="col-md-3" id="event_image_edit">
													<?php
														if(get_post_meta($post_edit->ID,'_event_image_id',true)!=''){
														?>
														<button type="button" onclick="event_post_image('event_image_div');"  class="btn btn-xs green-haze">
														<?php esc_html_e('Edit', 'ivdirectories' ); ?></button> &nbsp;<button type="button" onclick="remove_event_image('event_image_div');"  class="btn btn-xs green-haze"><?php esc_html_e('Remove', 'ivdirectories' ); ?></button>
														<?php
														}else{ ?>
														<button type="button" onclick="event_post_image('event_image_div');"  class="btn btn-xs green-haze"><?php esc_html_e('Add','ivdirectories'); ?></button>
														<?php
														}
													?>
												</div>
												<input type="hidden" name="event_image_id" id="event_image_id" value="<?php echo get_post_meta($post_edit->ID,'_event_image_id',true); ?>" >
											</div>
											<?php
												}else{
												esc_html_e('Please upgrade your account to add event ','ivdirectories');
											}
										?>
									</div>
								</div>
							</div>
							<div class="margiv-top-10">
								<div class="" id="update_message"></div>
								<input type="hidden" name="user_post_id" id="user_post_id" value="<?php echo esc_html($curr_post_id); ?>">
								<button type="button" onclick="iv_update_post();"  class="btn green-haze"><?php esc_html_e('Save Post','ivdirectories'); ?></button>
							</div>
						</form>
					</div>
				</div>
				<?php
				} // for Role
			?>
		</div>
	</div>
</div>
<!-- END PROFILE CONTENT -->
<?php
	$my_theme = wp_get_theme();
	$theme_name= strtolower($my_theme->get( 'Name' ));
	wp_enqueue_script('iv_directories-ar-script-27', wp_iv_directories_URLPATH . 'admin/files/js/add-edit-listing.js');
	wp_localize_script('iv_directories-ar-script-27', 'dirpro_data', array(
	'ajaxurl' 			=> admin_url( 'admin-ajax.php' ),
	'loading_image'		=> '<img src="'.wp_iv_directories_URLPATH.'admin/files/images/loader.gif">',
	'current_user_id'	=>get_current_user_id(),
	'image10'	=>esc_html__('image','ivdirectories'),
	'myaccount'=> wp_create_nonce("myaccount"),
	'permalink'=> get_permalink(),
	'wp_iv_directories_URLPATH'=> wp_iv_directories_URLPATH,
	'theme_name'				=> $theme_name,
	) );
	wp_enqueue_script('iv_directories-ar-map', wp_iv_directories_URLPATH . 'admin/files/js/add-edit-listing-map.js');
	wp_localize_script('iv_directories-ar-map', 'dirpro_map_data', array(
	'ajaxurl' 			=> admin_url( 'admin-ajax.php' ),
	'latitude' =>	get_post_meta($post_edit->ID,'latitude',true),
	'longitude'=> get_post_meta($post_edit->ID,'longitude',true),		
	) );
?>	